/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.internal;

import com.aptana.terminal.IProcessConfiguration;
import com.aptana.terminal.TerminalPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public final class ProcessConfigurations {
    private static final String EXTENSION_POINT_ID = "com.aptana.terminal.processConfigurations";
    private static final String TAG_CONFIGURATION = "configuration";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    private static final String ATT_PLATFORM = "platform";
    private static ProcessConfigurations instance = null;
    private List<IProcessConfiguration> configurations = new ArrayList<IProcessConfiguration>();

    private ProcessConfigurations() {
        this.readExtensionRegistry();
    }

    public static ProcessConfigurations getInstance() {
        if (instance == null) {
            instance = new ProcessConfigurations();
        }
        return instance;
    }

    private void readExtensionRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i], TAG_CONFIGURATION);
            ++i;
        }
    }

    private void readElement(IConfigurationElement element, String elementName) {
        if (!elementName.equals(element.getName())) {
            return;
        }
        if (TAG_CONFIGURATION.equals(element.getName())) {
            String id = element.getAttribute(ATT_ID);
            if (id == null || id.length() == 0) {
                return;
            }
            String name = element.getAttribute(ATT_NAME);
            if (name == null || name.length() == 0) {
                return;
            }
            String clazz = element.getAttribute(ATT_CLASS);
            if (clazz == null || clazz.length() == 0) {
                return;
            }
            String platform = element.getAttribute(ATT_PLATFORM);
            if (platform == null || platform.length() == 0) {
                return;
            }
            if (platform.equals(Platform.getOS())) {
                try {
                    this.configurations.add((IProcessConfiguration)element.createExecutableExtension(ATT_CLASS));
                }
                catch (CoreException e) {
                    TerminalPlugin.log("Process configuration instantiation failed.", e);
                }
            }
        }
    }

    public IProcessConfiguration[] getProcessConfigurations() {
        return this.configurations.toArray(new IProcessConfiguration[this.configurations.size()]);
    }
}

